(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"15b1323b-7add-4998-8d52-acebedd81dea"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.base_color_shader != undefined and mtl.base_color_connected do 
				append res #("base_color", mtl.base_color_shader)

			if mtl.diffuse_weight_shader != undefined and mtl.diffuse_weight_connected do 
				append res #("diffuse_weight",   mtl.diffuse_weight_shader, "resultFloat")

			if mtl.edge_color_shader != undefined and mtl.edge_color_connected do 
				append res #("pearl_color",      mtl.edge_color_shader)

			if mtl.edge_color_bias_shader != undefined and mtl.edge_color_bias_connected do 
				append res #("pearl_angle",      mtl.edge_color_bias_shader, "resultFloat")

			if mtl.lit_color_shader != undefined and mtl.lit_color_connected do 
				append res #("metal_color",      mtl.lit_color_shader)

			if mtl.spec_weight_shader != undefined and mtl.spec_weight_connected do 
				append res #("metal_weight",     mtl.spec_weight_shader, "resultFloat")

			if mtl.flake_color_shader != undefined and mtl.flake_color_connected do 
				append res #("flake_color",      mtl.flake_color_shader)

			if mtl.flake_density_shader != undefined and mtl.flake_density_connected do 
				append res #("flake_density",    mtl.flake_density_shader, "resultFloat") 

			if mtl.flake_scale_shader != undefined and mtl.flake_scale_connected do 
				append res #("flake_size",       mtl.flake_scale_shader, "resultFloat") 

			if mtl.reflection_color_shader != undefined and mtl.reflection_color_connected do 
				append res #("coat_color",       mtl.reflection_color_shader) 

			if mtl.reflection_edge_weight_shader != undefined and mtl.reflection_edge_weight_connected do 
				append res #("coat_high",        mtl.reflection_edge_weight_shader, "resultFloat") 

			if mtl.reflection_base_weight_shader != undefined and mtl.reflection_base_weight_connected do 
				append res #("coat_low",         mtl.reflection_base_weight_shader, "resultFloat") 

			if mtl.edge_factor_shader != undefined and mtl.edge_factor_connected do 
				append res #("coat_exponent",    mtl.edge_factor_shader, "resultFloat") 

			if mtl.dirt_color_shader != undefined and mtl.dirt_color_connected do 
				append res #("dirt_color",       mtl.dirt_color_shader) 

			if mtl.dirt_weight_shader != undefined and mtl.dirt_weight_connected do 
				append res #("dirt_mix",         mtl.dirt_weight_shader, "resultFloat") 

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("base_color",       mtl.base_color)
			append res #("diffuse_weight",   mtl.diffuse_weight)
			append res #("pearl_color",      mtl.edge_color)
			append res #("pearl_mix",        1.0)
			append res #("pearl_angle",      mtl.edge_color_bias)

			append res #("metal_color",      mtl.lit_color)
			append res #("metal_weight",     mtl.spec_weight)
			append res #("metal_gloss",      mtl.lit_color_bias / 20.0) -- totally fudged

			append res #("flake_color",      mtl.flake_color)

			-- flake weight is completely non-physical in the mr shader and has to be fudged completely
			append res #("flake_weight",     mtl.flake_weight / 3.0)
			append res #("flake_gloss",      mtl.flake_exp / 100.0) -- totally fudged
			append res #("flake_perturb",    mtl.flake_strength / 10.0) 
			append res #("flake_density",    mtl.flake_density) 
			append res #("flake_size",       mtl.flake_scale) 

			append res #("coat_color",       mtl.reflection_color) 
			append res #("coat_high",        mtl.reflection_edge_weight) 
			append res #("coat_low",         mtl.reflection_base_weight) 
			append res #("coat_exponent",    mtl.edge_factor) 
			append res #("coat_gloss",       (1.0 - mtl.glossy_spread)) 

			append res #("dirt_color",       mtl.dirt_color) 
			append res #("dirt_mix",         mtl.dirt_weight) 

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBu/yljYYXowl7A556AC4UFPXGsjkgWHcN/
-- mgCEBma2gqZddFjmOuJprKwfTdi0UM5pP3ySZMSUSdhtk2H9MzNUwQM+JjaEWSxL
-- XnalUh89v6sishqVldIFxzDIWUtmPOuES273wwsjLxJHO7NYPvD6aNtHSPbmHGw0
-- DJYy3HVTRR4MJ4DeAKYN0Y7Bo6zOLRQllO0EAWU4s+yqKLb1xHv/3OtoCunAMHuZ
-- 49LNqDegoQmgvs0X9s2j6V7W5jn7mu/lDn94n9478LI2AkWww9HMsautTg2qFaWw
-- r07b574OND05QReanvoSNixJwyq9QLe8YIei+XInKWQifLSEKpU/
-- -----END-SIGNATURE-----